/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard;

import DE.siemens.ad.logo.dialog.wizard.AbstractWizardProgressPanel;
import DE.siemens.ad.logo.dialog.wizard.ProgressInfo;
import DE.siemens.ad.logo.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class DefaultWizardProgressPanel
extends AbstractWizardProgressPanel {
    protected JLabel headerLabel;
    protected JLabel fLblTimeLeft;
    protected JProgressBar progressBar;
    protected JLabel fLblNote;

    public DefaultWizardProgressPanel() {
        this.setLayout(new GridBagLayout());
        this.headerLabel = new JLabel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        this.add((Component)this.headerLabel, gbc);
        this.fLblTimeLeft = new JLabel();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        this.add((Component)this.fLblTimeLeft, gbc);
        this.progressBar = new JProgressBar();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        this.add((Component)this.progressBar, gbc);
        this.fLblNote = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        this.add((Component)this.fLblNote, gbc);
    }

    public void setProgress(Object source, final ProgressInfo progressInfo) {
        this.fLblNote.setText(progressInfo.getNote());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultWizardProgressPanel.this.progressBar.setValue(progressInfo.getCurrent());
                float elapsedTime = progressInfo.getElapsedTime();
                float min = progressInfo.getMin();
                float max = progressInfo.getMax();
                float currentValue = progressInfo.getCurrent();
                if (elapsedTime > 5000.0f && max - min > 0.0f && currentValue > 0.0f) {
                    float overallTime = elapsedTime / (currentValue / (max - min));
                    String times = DefaultWizardProgressPanel.this.formatTimeString((long)elapsedTime, (long)overallTime);
                    DefaultWizardProgressPanel.this.fLblTimeLeft.setText(times);
                }
            }
        });
    }

    public void setProgressInfo(ProgressInfo progressInfo) {
        super.setProgressInfo(progressInfo);
        this.headerLabel.setText(progressInfo.getTitle());
        this.progressBar.setMaximum(progressInfo.getMax());
        this.progressBar.setMinimum(progressInfo.getMin());
    }

    private String formatTimeString(long elapsedTime, long overallTime) {
        long elapsedHours = elapsedTime / 3600000L;
        long elapsedMinutes = elapsedTime / 60000L % 60L;
        long elapsedSeconds = elapsedTime / 1000L % 60L;
        long overallHours = overallTime / 3600000L;
        long overallMinutes = overallTime / 60000L % 60L;
        long overallSeconds = overallTime / 1000L % 60L;
        String elapsedString = Util.addLeadingZeros("" + elapsedMinutes, 2) + ":" + Util.addLeadingZeros("" + elapsedSeconds, 2);
        String overallString = Util.addLeadingZeros("" + overallMinutes, 2) + ":" + Util.addLeadingZeros("" + overallSeconds, 2);
        if (overallHours >= 1L) {
            elapsedString = elapsedHours + ":" + elapsedString;
            overallString = overallHours + ":" + overallString;
        }
        return elapsedString + " / " + overallString;
    }
}

